﻿<?LassoScript
	auth_admin;
	
	// Determine the current directory
	var: 'location' = (string: response_localpath);
	var: 'filename' = $location->(split: '/')->(last)->(split: '\\')->(last);
	$location->(removetrailing: $filename);

	// Determine the parent directory
	var: 'parent' = $location;
	$parent->(removetrailing: '/');
	$parent->(removetrailing: '\\');
	var: 'dirname' = $parent->(split: '/')->(last)->(split: '\\')->(last);
	$parent->(removetrailing: $dirname);
	
	// Establish the LassoApp parameters
	var: 'entry' = 'rpc.lasso';
	var: 'root' = $location;
	var: 'result' = $parent + $dirname + '.LassoApp';

	// Build the LassoApp
	var: 'output' = (LassoApp_Create: -Entry=$entry, -Root=$root, -Result=$result);

?>

<html>
	<head>
		<title>Build LassoApp</title>
	</head>
	<body>
		<h3>Build LassoApp</h3>
		
		<p>Entry - [var: 'entry']</p>

		<p>Root - [var: 'root']</p>

		<p>Result - [var: 'result']</p>

		<p>Output - [var: 'output'] </p>
[protect]
		<p>List - [LassoApp_List->(Join: ', ')]</p>
[/protect]
		<p>Error - ([error_currenterror: -errorcode]) [error_currenterror]
	</body>
</html>
